;/*****************************************************************************
; * startup_LPC18xx.s 
; *
; * @file:    startup_LPC18xx.s
; * @purpose: CMSIS Cortex-M3 Core Device Startup File 
; *           for the NXP LPC18xx Device Series 
; * @version: V1.0
; * @date:    25. Nov. 2008
; *------- <<< Use Configuration Wizard in Context Menu >>> ------------------
; *
; * Copyright (C) 2008 ARM Limited. All rights reserved.
; * ARM Limited (ARM) is supplying this software for use with Cortex-M3 
; * processor based microcontrollers.  This file can be freely distributed 
; * within development tools that are supporting such ARM based processors. 
; *
; * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
; * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
; * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
; * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
; * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
; *
; *****************************************************************************/


; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000200

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000000

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit


                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors

Sign_Value      EQU     0x5A5A5A5A


__Vectors       DCD     __initial_sp              ; 0 Top of Stack
                DCD     Reset_Handler             ; 1 Reset Handler
                DCD     NMI_Handler               ; 2 NMI Handler
                DCD     HardFault_Handler         ; 3 Hard Fault Handler
                DCD     MemManage_Handler         ; 4 MPU Fault Handler
                DCD     BusFault_Handler          ; 5 Bus Fault Handler
                DCD     UsageFault_Handler        ; 6 Usage Fault Handler
                DCD     Sign_Value                ; 7 Reserved
                DCD     0                         ; 8 Reserved
                DCD     0                         ; 9 Reserved
                DCD     0                         ; 10 Reserved
                DCD     SVC_Handler               ; 11 SVCall Handler
                DCD     DebugMon_Handler          ; 12 Debug Monitor Handler
                DCD     0                         ; 13 Reserved
                DCD     PendSV_Handler            ; 14 PendSV Handler
                DCD     SysTick_Handler           ; 15 SysTick Handler

                ; External Interrupts
                DCD DAC_IRQHandler              ; 16
                DCD WIC_IRQHandler              ; 17
                DCD DMA_IRQHandler              ; 18
                DCD EDM_IRQHandler              ; 19
                DCD SCI_IRQHandler              ; 20
                DCD ETH_IRQHandler              ; 21
                DCD SDIO_IRQHandler             ; 22
                DCD LCD_IRQHandler              ; 23
                DCD USB0_IRQHandler             ; 24
                DCD USB1_IRQHandler             ; 25
                DCD SCT_IRQHandler              ; 26
                DCD RIT_IRQHandler              ; 27
                DCD TIMER0_IRQHandler           ; 28
                DCD TIMER1_IRQHandler           ; 29
                DCD TIMER2_IRQHandler           ; 30
                DCD TIMER3_IRQHandler           ; 31
                DCD MCPWM_IRQHandler            ; 32
                DCD ADC0_IRQHandler             ; 33
                DCD I2C0_IRQHandler             ; 34
                DCD I2C1_IRQHandler             ; 35
                DCD SPI_IRQHandler              ; 36
                DCD ADC1_IRQHandler             ; 37
                DCD SSP0_IRQHandler             ; 38
                DCD SSP1_IRQHandler             ; 39
                DCD UART0_IRQHandler            ; 40
                DCD UART1_IRQHandler            ; 41
                DCD UART2_IRQHandler            ; 42
                DCD UART3_IRQHandler            ; 43
                DCD I2S_IRQHandler              ; 44
                DCD AES_IRQHandler              ; 45
                DCD SPIFI_IRQHandler            ; 46

                                                


                IF      :LNOT::DEF:NO_CRP
                AREA    |.ARM.__at_0x02FC|, CODE, READONLY
CRP_Key         DCD     0xFFFFFFFF
                ENDIF


                AREA    |.text|, CODE, READONLY


; Reset Handler

Reset_Handler   PROC
                EXPORT  Reset_Handler             [WEAK]

                IF      :DEF:__MICROLIB
                IMPORT  __main
                LDR     R0, =__main
                ELSE
                IMPORT  main
                LDR     R0, =main
                ENDIF

                BX      R0
                ENDP


; Dummy Exception Handlers (infinite loops which can be modified)                

NMI_Handler     PROC
                EXPORT  NMI_Handler               [WEAK]
                B       .
                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler         [WEAK]
                B       .
                ENDP
MemManage_Handler\
                PROC
                EXPORT  MemManage_Handler         [WEAK]
                B       .
                ENDP
BusFault_Handler\
                PROC
                EXPORT  BusFault_Handler          [WEAK]
                B       .
                ENDP
UsageFault_Handler\
                PROC
                EXPORT  UsageFault_Handler        [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler               [WEAK]
                B       .
                ENDP
DebugMon_Handler\
                PROC
                EXPORT  DebugMon_Handler          [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler            [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler           [WEAK]
                B       .
                ENDP

Default_Handler PROC

                EXPORT DAC_IRQHandler       [WEAK]
                EXPORT WIC_IRQHandler       [WEAK]
                EXPORT DMA_IRQHandler       [WEAK]
                EXPORT EDM_IRQHandler       [WEAK]
                EXPORT SCI_IRQHandler       [WEAK]
                EXPORT ETH_IRQHandler       [WEAK]
                EXPORT SDIO_IRQHandler      [WEAK]
                EXPORT LCD_IRQHandler       [WEAK]
                EXPORT USB0_IRQHandler      [WEAK]
                EXPORT USB1_IRQHandler      [WEAK]
                EXPORT SCT_IRQHandler       [WEAK]
                EXPORT RIT_IRQHandler       [WEAK]
                EXPORT TIMER0_IRQHandler    [WEAK]
                EXPORT TIMER1_IRQHandler    [WEAK]
                EXPORT TIMER2_IRQHandler    [WEAK]
                EXPORT TIMER3_IRQHandler    [WEAK]
                EXPORT MCPWM_IRQHandler     [WEAK]
                EXPORT ADC0_IRQHandler      [WEAK]
                EXPORT I2C0_IRQHandler      [WEAK]
                EXPORT I2C1_IRQHandler      [WEAK]
                EXPORT SPI_IRQHandler       [WEAK]
                EXPORT ADC1_IRQHandler      [WEAK]
                EXPORT SSP0_IRQHandler      [WEAK]
                EXPORT SSP1_IRQHandler      [WEAK]
                EXPORT UART0_IRQHandler     [WEAK]
                EXPORT UART1_IRQHandler     [WEAK]
                EXPORT UART2_IRQHandler     [WEAK]
                EXPORT UART3_IRQHandler     [WEAK]
                EXPORT I2S_IRQHandler       [WEAK]
                EXPORT AES_IRQHandler       [WEAK]
                EXPORT SPIFI_IRQHandler     [WEAK]

                


DAC_IRQHandler      
WIC_IRQHandler      
DMA_IRQHandler      
EDM_IRQHandler      
SCI_IRQHandler      
ETH_IRQHandler      
SDIO_IRQHandler     
LCD_IRQHandler      
USB0_IRQHandler     
USB1_IRQHandler     
SCT_IRQHandler      
RIT_IRQHandler      
TIMER0_IRQHandler   
TIMER1_IRQHandler   
TIMER2_IRQHandler   
TIMER3_IRQHandler   
MCPWM_IRQHandler        
ADC0_IRQHandler     
I2C0_IRQHandler     
I2C1_IRQHandler     
SPI_IRQHandler      
ADC1_IRQHandler     
SSP0_IRQHandler     
SSP1_IRQHandler     
UART0_IRQHandler        
UART1_IRQHandler        
UART2_IRQHandler        
UART3_IRQHandler        
I2S_IRQHandler      
AES_IRQHandler      
SPIFI_IRQHandler        
    
        

                B       .

                ENDP


                ALIGN


; User Initial Stack & Heap

                IF      :DEF:__MICROLIB
                
                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit
                
                ELSE
                
                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap
__user_initial_stackheap

                LDR     R0, =  Heap_Mem
                LDR     R1, =(Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR

                ALIGN

                ENDIF


                END
